% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSoundscapeData.R
\name{loadSoundscapeData}
\alias{loadSoundscapeData}
\title{Load Soundscape Data}
\usage{
loadSoundscapeData(
  x,
  needCols = c("UTC"),
  skipCheck = FALSE,
  timeBin = NULL,
  binFunction = "median",
  binCount = FALSE,
  octave = c("original", "tol", "ol"),
  label = NULL,
  keepQuals = c(1),
  keepEffort = TRUE,
  dropNonHmd = TRUE,
  tz = "UTC",
  extension = c("nc", "csv")
)
}
\arguments{
\item{x}{a dataframe, path to a CSV file, or path to a MANTA
NetCDF file, or folder containing these. If \code{x} is a vector
of file paths then all will be read in and combined. If \code{x}
is a folder, then all files with extension \code{extension} will
be loaded. Note this will not load files within subfolders, only
the main folder.}

\item{needCols}{names of columns that must be present in \code{x},
if any are missing will trigger an error}

\item{skipCheck}{logical flag to skip some data checking, recommended
to keep as \code{FALSE}}

\item{timeBin}{amount of time to bin data by, format can
be "#Unit" e.g. \code{'2hour'} or \code{'1day'}}

\item{binFunction}{summary function to apply to data in each time bin,
default is "median"}

\item{binCount}{logical flag to return the number of times in
each time bin as column "binCount"}

\item{octave}{one of "original", "tol", or "ol". If "original" then
nothing happens, otherwise data are converted to Octave-leve ("ol")
or Third-Octave-Level ("tol") measurements using
\link{createOctaveLevel}}

\item{label}{optional, if not \code{NULL} then this value will be
added as an additional column "label" to the output}

\item{keepQuals}{quality flag values to keep. Accepts vector of
integers from (1, 2, 3, 4) corresponding to flag labels "Good",
"Not evaluated/Unknown", "Compromised/Questionable", and "Unusable/Bad".
HMD levels for points with data quality flags outside of \code{keepQuals}
will be marked as \code{NA}.}

\item{keepEffort}{if \code{TRUE} or \code{FALSE}, a logical flag whether or
not to keep the effort information with the outputs (number of seconds
per minute). If a numeric value, then any minutes with an effort value
less than \code{keepEffort} will be removed (e.g. \code{50} will remove
minutes with less than 50 seconds of effort)}

\item{dropNonHmd}{logical flag to drop non-standard hybrid millidecade
bands, only applies to HMD type data. Some datasets have frequency
values that are not part of the standard HMD bands (e.g. at exactly
the Nyquist rate), if \code{TRUE} these will be removed.}

\item{tz}{timezone of the data being loaded, will be converted to UTC
after load}

\item{extension}{only used if \code{x} is a folder, the file extension
to load. Must be one of "nc" or "csv"}
}
\value{
a dataframe
}
\description{
Reads and checks data to ensure formatting will work
for other \code{PAMscapes} functions. Will read and check the
formatting of CSV files, or check the formatting of dataframes.
Can also read in MANTA NetCDF files and format the data
appropriately.
}
\details{
Files created by MANTA and Triton software will be
reformatted to have consisitent formatting. The first column
will be renamed to "UTC", and columns containing soundscape
metrics will be named using the convention "TYPE_FREQUENCY",
e.g. "HMD_1", "HMD_2" for Manta hybrid millidecade mesaurements.

Inputs from sources other than MANTA or Triton can be accepted
in either "wide" or "long" format. Wide format must follow
the conventions above - first column "UTC", other columns
named by "TYPE_FREQUENCY" where TYPE is consistent across all
columns and FREQUENCY is in Hertz. Long format data must have
the following columns:
\describe{
\item{"UTC"}{ - time of the measurement, in UTC timezone}
\item{"type"}{ - the type of soundscape measurement e.g.
PSD or OL, must be the same for all}
\item{"frequency"}{ - the frequency of the measurement, in Hertz}
\item{"value"}{ - the soundscape measurement value, usually dB}
}
}
\examples{

manta <- loadSoundscapeData(system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes'))
str(manta)
ol <- loadSoundscapeData(system.file('extdata/OLSmall.csv', package='PAMscapes'))
str(ol)
psd <- loadSoundscapeData(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
str(psd)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
