% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScaledTimeseries.R
\name{plotScaledTimeseries}
\alias{plotScaledTimeseries}
\title{Plot Rescaled Timeseries}
\usage{
plotScaledTimeseries(
  x,
  columns,
  title = NULL,
  units = NULL,
  color = hue_pal(),
  cpal,
  lwd = 0.5,
  minVals = NA,
  relMax = 1,
  toTz = "UTC"
)
}
\arguments{
\item{x}{a dataframe with column \code{UTC}}

\item{columns}{the names of the columns to plot. Values of columns will
be rescaled to appear similar to range of the first column}

\item{title}{title for the plot}

\item{units}{name of units for plot labeling, default is taken from
common soundscape units}

\item{color}{colors to use for different lines, can either be a color
palette function or a vector of color names}

\item{cpal}{Deprecated in favor of \code{color} for naming consistency}

\item{lwd}{line width, either a single value or a vector of widths
matching the length of \code{columns}}

\item{minVals}{minimum value for each of \code{columns} to use for rescaling,
either a single value to use for all or a vector matching the length of
\code{columns}. A value of \code{NA} will use the minimum value present
in the data. See Details for more info}

\item{relMax}{the percentage of the maximum value for all rescaled columns
relative to the first column. See Details for more info}

\item{toTz}{timezone to use for the time axis (input data must be UTC).
Specification must be from \link{OlsonNames}}
}
\value{
a ggplot object
}
\description{
Plot timeseries of different values, rescaled so
that multiple types of data are visible on the same plot
}
\details{
The data in the different \code{columns} of \code{x} may have
very different ranges, so they must be rescaled in order to create a
useful comparison plot. The default behavior is to rescale all columns
to have the same min/max range as the first column in \code{columns}.
This means that the Y-axis values will only be accurate for the first
column, and all lines will have their minimum value at the bottom edge
of the plot and their maximum value at the top edge of the plot.

There are some cases where this full-range rescaling is not desirable.
One case is when one of the variables should have a minimum value of
zero, but the lowest value present in your data is larger than zero.
For example, wind speed might in your data might range from values of
0.5 to 3, so by default this 0.5 value would appear at the bottom of the
plot. However, it would make much more sense if the values were plotted
relative to a minimum of zero. The \code{minVals} argument lets you control
this. The default \code{NA} value uses the minimum of your data range, but
you can provide a value of zero (or anything else) to control the displayed
minimum.

It can also be distracting or busy to display all lines at the same relative
height, especially as the number of columns displayed grows. There are two
ways to help this. First, the \code{lwd} parameter can be used to display
certain lines more prominently, making it easier to keep track of more
important information. Second, the \code{relMax} can be used to control the
maximum relative height of each line plot. The default value of 1 makes each
line the same maximum height as the first column, reducing this to a value of
0.75 would make it so that all lines other than the first will not go higher than
75\% of the Y-axis
}
\examples{
manta <- loadSoundscapeData(system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes'))
plotScaledTimeseries(manta, columns=c('HMD_50', 'HMD_100', 'HMD_200'))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
