% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_Beta.R
\name{power_Beta}
\alias{power_Beta}
\title{Power Calculations for Test of Two Beta Means}
\usage{
power_Beta(n1 = NULL, n2 = NULL,  mu1 = NULL, mu2 = NULL, 
sd1 = NULL, sd2 = NULL, sig.level = 0.05, power = NULL, 
equal.sample = TRUE, equal.precision = TRUE, trials = 100, 
link.type = c("logit", "probit", "cloglog", "cauchit", "log", "loglog"))
}
\arguments{
\item{n1}{sample size in group 1, or sample size in each group if \code{equal.sample = TRUE}}

\item{n2}{sample size in group 2}

\item{mu1}{sample mean of group 1}

\item{mu2}{sample mean of group 2}

\item{sd1}{standard deviation for group 1}

\item{sd2}{standard deviation for group 2. Only applicable when \code{equal.precision = FALSE}}

\item{sig.level}{significance level (Type I error probability)}

\item{power}{power of test (1 minus Type II error probability)}

\item{equal.sample}{equal sample sizes for two groups, see details}

\item{equal.precision}{equal dispersion parameter assumption in simulation}

\item{trials}{number of trials in simulation}

\item{link.type}{type of link used in the beta regression, see details}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with method and note elements.
}
\description{
Compute the power for a test of two sample means with beta distributions, or determine the minimum sample size to obtain a target power.
}
\details{
Exactly one of the parameters \code{n1}, \code{n2} and \code{power} must be passed as NULL, and that parameter is determined from the others.\cr\cr
If equal.sample = TRUE is used, exactly one of the parameters \code{n1} and \code{power} must be passed as NULL, and N in output will denote the number in each group. \cr\cr
This function allows you to set the number of trials in the simulation to control the result accuracy,
and type of link used in the beta regression. You can choose one of the following: "logit", "probit", "cloglog", "cauchit", "log", "loglog".
}
\examples{
# calculate power
power_Beta(n1 = 60, mu1 = 0.5, mu2 = 0.80, sd1 = 0.25)
# calculate sample size for both groups
power_Beta(mu1 = 0.5, mu2 = 0.80, sd1 = 0.25, power = 0.8)
}
