# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Retrieve indices for a rolling window analysis
#'
#' @param y_var NumericVector. Input on which to define the indices for each roll of
#'   the window
#' @param window_size int. The size of the window
#' @return a list in which each element contains \code{window_size} consecutive
#'   integers that indicate which elements of \code{y_var} would be extracted
#'   for that roll of the window
#' @export
#' @note For this function, the output elements contain positions (i.e., indices) from
#'   \code{y_var}, whereas for \code{\link{rolling_groups}} the output elements
#'   contain the raw values found at each index
#' @seealso \code{\link{rolling_groups}}
#' @examples
#' result <- get_indices(1:100, 10)
#' head(result)
#' tail(result)
get_indices <- function(y_var, window_size = 15L) {
    .Call(`_PAutilities_get_indices`, y_var, window_size)
}

#' Loop along a vector, returning n elements at a time in a list
#'
#' @param values IntegerVector. The vector to loop along
#' @param n int. The number of elements to return in each element of the
#'   resulting list
#' @return a list in which each element contains \code{n} elements from
#'   \code{values}
#' @export
#' @note For this function, the output elements contain raw values from
#'   \code{values}, whereas for \code{\link{get_indices}} the output elements
#'   contain the positions (i.e., indices) rather than the raw values
#' @seealso \code{\link{get_indices}}
#' @examples
#' groups <- rolling_groups(0:50, 3)
#' head(groups)
#' tail(groups)
rolling_groups <- function(values, n = 2L) {
    .Call(`_PAutilities_rolling_groups`, values, n)
}

