\name{makeAD}
\alias{makeAD}
\title{ Make an Executable Binary File from a C File }
\description{
  Essentially a wrapper function that calls in sequence: \code{convAD},
  \code{compAD}, and \code{linkAD}.
}
\usage{
makeAD(prefix, raneff=FALSE, safe=TRUE, logfile=TRUE, verbose=TRUE)
}
\arguments{
  \item{prefix}{string name prefix of the ADMB project (e.g., \code{"vonb"}).}
  \item{raneff}{logical: use the random effects model, otherwise use the normal model.}
  \item{safe}{logical: if \code{TRUE}, use safe mode with bounds checking on all
    array objects, otherwise use optimized mode for fastest execution.}
  \item{logfile}{logical: if \code{TRUE}, create a log file of the messages from the shell call.}
  \item{verbose}{logical: if \code{TRUE}, report the shell call an its messages to the R console.}
}
\details{
  This function uses the C++ comiler declared in \code{.ADopts}. If \code{logfile=TRUE},
  any errors will appear in \code{'prefix'.log}. If \code{verbose=TRUE},
  they will appear in the R console.
}
\value{
  Returns nothing. The three functions called by \code{makeAD} each 
  return the shell call and its messages.
}
\author{ Jon T. Schnute, Pacific Biological Station, Nanaimo BC, Canada }
\note{
  A wrapper function that can be called from a GUI exists as \code{.win.makeAD}.
}
\seealso{ \code{\link{convAD}}, \code{\link{compAD}}, \code{\link{linkAD}}, \code{\link{cleanAD}} }
\keyword{programming}
\keyword{interface}
