% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMParam.R
\name{PCMParamType}
\alias{PCMParamType}
\alias{is.Local}
\alias{is.Global}
\alias{is.ScalarParameter}
\alias{is.VectorParameter}
\alias{is.MatrixParameter}
\alias{is.WithCustomVecParams}
\alias{is.Fixed}
\alias{is.Zeros}
\alias{is.Ones}
\alias{is.Identity}
\alias{is.AllEqual}
\alias{is.NonNegative}
\alias{is.Diagonal}
\alias{is.ScalarDiagonal}
\alias{is.Symmetric}
\alias{is.UpperTriangular}
\alias{is.UpperTriangularWithDiagonal}
\alias{is.WithNonNegativeDiagonal}
\alias{is.LowerTriangular}
\alias{is.LowerTriangularWithDiagonal}
\alias{is.Omitted}
\alias{is.CholeskyFactor}
\alias{is.Schur}
\alias{is.Transformable}
\alias{is.Transformed}
\alias{is.SemiPositiveDefinite}
\title{Parameter types}
\usage{
is.Local(o)

is.Global(o)

is.ScalarParameter(o)

is.VectorParameter(o)

is.MatrixParameter(o)

is.WithCustomVecParams(o)

is.Fixed(o)

is.Zeros(o)

is.Ones(o)

is.Identity(o)

is.AllEqual(o)

is.NonNegative(o)

is.Diagonal(o)

is.ScalarDiagonal(o)

is.Symmetric(o)

is.UpperTriangular(o)

is.UpperTriangularWithDiagonal(o)

is.WithNonNegativeDiagonal(o)

is.LowerTriangular(o)

is.LowerTriangularWithDiagonal(o)

is.Omitted(o)

is.CholeskyFactor(o)

is.Schur(o)

is.Transformable(o)

is.Transformed(o)

is.SemiPositiveDefinite(o)
}
\arguments{
\item{o}{an object, i.e. a PCM or a parameter object.}
}
\value{
logical indicating if the object passed is from the type appearing in
the function-name.
}
\description{
The parameter types are divided in the following categories:
\describe{
\item{Main type}{These are the "ScalarParameter", "VectorParameter" and "MatrixParameter"
classes. Each model parameter must have a main type.}
\item{Scope/Omission}{These are the "_Global" and "_Omitted" classes. Every
parameter can be global for all regimes or local for a single regime. If not
specified, local scope is assumed. In some special cases a parameter (e.g.
Sigmae can be omitted from a model. This is done by adding "_Omitted" to its
class attribute.}
\item{Constancy (optional)}{These are the "_Fixed", "_Ones", "_Identity" and
"_Zeros" classes.}
\item{Transformation (optional)}{These are the "_Transformable", "_CholeskyFactor"
 and "_Schur" classes. }
\item{Other properties (optional)}{These are the "_NonNegative",
"_WithNonNegativeDiagonal", "_LowerTriangular", "_AllEqual", "_ScalarDiagonal",
"_Symmetric", "_UpperTriangular", "_LowerTriangularWithDiagonal" and
"_UpperTriangularWithDiagonal" classes.}
}
}
\section{Functions}{
\itemize{
\item \code{is.Local}: 

\item \code{is.Global}: 

\item \code{is.ScalarParameter}: 

\item \code{is.VectorParameter}: 

\item \code{is.MatrixParameter}: 

\item \code{is.WithCustomVecParams}: 

\item \code{is.Fixed}: 

\item \code{is.Zeros}: 

\item \code{is.Ones}: 

\item \code{is.Identity}: 

\item \code{is.AllEqual}: 

\item \code{is.NonNegative}: 

\item \code{is.Diagonal}: 

\item \code{is.ScalarDiagonal}: 

\item \code{is.Symmetric}: 

\item \code{is.UpperTriangular}: 

\item \code{is.UpperTriangularWithDiagonal}: 

\item \code{is.WithNonNegativeDiagonal}: 

\item \code{is.LowerTriangular}: 

\item \code{is.LowerTriangularWithDiagonal}: 

\item \code{is.Omitted}: 

\item \code{is.CholeskyFactor}: 

\item \code{is.Schur}: 

\item \code{is.Transformable}: 

\item \code{is.Transformed}: 

\item \code{is.SemiPositiveDefinite}: 
}}

