% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMGenerateParameterizations}
\alias{PCMGenerateParameterizations}
\title{Generate possible parameterizations for a given type of model}
\usage{
PCMGenerateParameterizations(model,
  listParameterizations = PCMListParameterizations(model),
  tableParameterizations = PCMTableParameterizations(model,
  listParameterizations), env = .GlobalEnv,
  useModelClassNameForFirstRow = FALSE)
}
\arguments{
\item{model}{a PCM object.}

\item{listParameterizations}{a list or a sublist returned by `PCMListParameterizations`.
Default: `PCMListParameterizations(model)`.}

\item{tableParameterizations}{a data.table containing the parameterizations to
generate. By default this is generated from `listParameterizations` using a
call `PCMTableParameterizations(model, listParameterizations)`. If specified
by the user, this parameter takes precedence over `listParameterizations` and
`listParameterizations` is not used.}

\item{env}{an environment where the method definitions will be stored.
Default: `env = .GlobalEnv`.}

\item{useModelClassNameForFirstRow}{A logical specifying if the S3 class name of
`model` should be used as a S3 class for the model defined in the first row of
`tableParameterizations`. Default: FALSE.}
}
\value{
This function does not return a value. It only has a side effect by
defining S3 methods in `env`.
}
\description{
A parameterization of a PCM of given type, e.g. OU, is a PCM-class
inheriting from this type, which imposes some restrictions or transformations of
the parameters in the base-type. This function generates the S3 methods responsible
for creating such parameterizations, in particular it generates the definition
of the methods for the two S3 generics `PCMParentClasses` and `PCMSpecify` for
al parameterizations specified in the `tableParameterizations` argument.
}
