### This file is part of 'PGRdup' package for R.

### Copyright (C) 2014-2020, ICAR-NBPGR.
#
# PGRdup is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# PGRdup is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  https://www.r-project.org/Licenses/



#' Sample groundnut PGR passport data
#' 
#' Sample PGR passport data of 1000 groundnut accessions held in the Indian 
#' National Genebank at National Bureau of Plant Genetic Resources (NBPGR), New 
#' Delhi.
#' 
#' @name GN1000
#' @usage data(GN1000)
#' @keywords datasets
#' @format A data frame having 1000 records with the following 10 
#'   columns(fields): \itemize{ \item{CommonName}{ : }{Common name} 
#'   \item{BotanicalName}{ : }{Botanical name} \item{NationalID}{ : }{NBPGR 
#'   National identifier} \item{CollNo}{ : }{Collector number} \item{DonorID}{ :
#'   }{Donor ID} \item{OtherID1}{ : }{Other ID field 1} \item{OtherID2}{ : 
#'   }{Other ID field 2} \item{BioStatus}{ : }{Biological status}
#'   \item{SourceCountry}{ : }{Country of origin} \item{TransferYear}{ : }{Year
#'   of transfer} }
#' @seealso \url{http://www.nbpgr.ernet.in:8080/PGRPortal/}
#'   
NULL
