% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology.R
\name{phenology}
\alias{phenology}
\title{Calculate phenological events}
\usage{
phenology(
  x,
  model,
  parametrisation = NULL,
  year = NULL,
  hatch = NULL,
  return_date = TRUE,
  ...
)
}
\arguments{
\item{x}{SpatRaster list/dataframe (tmean, tmax, tmin) - numeric - with time attribute/date column}

\item{model}{name of model - character}

\item{parametrisation}{name of parametrisation - character}

\item{year}{year for prognosis - numeric}

\item{hatch}{SpatRaster - logical - with time attribute TRUE/FALSE hatch/no_hatch}

\item{return_date}{returns start of phenological event with time serial number}

\item{...}{parameter to change default values. (i.e. ldt = 3.5)}
}
\value{
If return_date is TRUE returns single layered SpatRaster with timeserialnumber (start day of phenological event).
If return_date is FALSE returns a one layer per day SpatRaster logical with phenological event occured/not TRUE/FALSE.
}
\description{
Using daily mean or min and max temperature data the function
calculates the temperature dependent development stage of OPM or different
phenological models like bud swelling or leaf unfolding of Quercus robur.
Its using the models & model-parameters of Halbig et al. 202x. It follows
4 different steps:
\itemize{
\item a) Calculating and Summing up cold days or frost days.
(cold days are defined as days with a mean temp under ldt (lower
development threshold) while frost days are all days with a min temperature
under ldt)
\item b) Hatch dependent development stages need a hatch raster (hatch
happened 1 or not 0) for each day
\item c) Calculating Degree Days with the
single sine method of Baskerville and Emin, 1969
\item d) Calculate the needed
sum of effective temperatures for the development stage Comparing when the
growing degree days(cumsum of degree days) is higher than the calculated
threshold
}
}
\examples{
## SpatRaster
srl <- load_test()

# calculate budswelling of quercus robur
budswelling <- phenology(srl, "budswelling", "quercus_robur_type1", year = 2020)

}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{mortality}()},
\code{\link{parameter}()},
\code{\link{phenthau}()}
}
\author{
Bachfischer Lorenz, Department forest protection FVA (2023)
\email{lorenz.bachfischer@posteo.de}
}
\concept{Main}
