% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replacements.R
\name{replace_values}
\alias{replace_values}
\title{replace symbols or other character flags}
\usage{
replace_values(x, flag_df, nonflag = NULL, as_numeric = TRUE)
}
\arguments{
\item{x}{vector to replace}

\item{flag_df}{dataframe with first column being the flag and second the replacement value}

\item{nonflag}{what to do with non-flagged elements}

\item{as_numeric}{whether to return column as numeric}
}
\description{
replace symbols or other character flags
}
\details{
because of R's coercion rules being somewhat unpredictable regarding character vs factor
the behavior of replace_values is to always treat as character data, even if passed in 
as a factor
}
\examples{
df <- data.frame(ID = 1, DV = c(1, "BQL", ".", 5))
rflags <- data.frame(flag = c("BQL", "."), replacement = -99)
df$DVR <- replace_values(df$DV, rflags)

library(dplyr)
df <- df \%>\% mutate(DVR2 = replace_values(DV, rflags))

# powerful with unique_non_numerics
df <- df \%>\% mutate(DVR3 = replace_values(DV, 
                                 data.frame(values = unique_non_numerics(DV), 
                                            replacement = NA)))
}
\seealso{
\code{\link{unique_non_numerics}}: to identify which non-numeric values must
be replaced before column can be safely coerced to a numeric
}
