% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_crosswalk.R
\name{pl_crosswalk}
\alias{pl_crosswalk}
\title{Download Block Crosswalk Files}
\usage{
pl_crosswalk(abbr, from_year = 2010L, to_year = from_year + 10L)
}
\arguments{
\item{abbr}{the state to download the crosswalk for.}

\item{from_year}{the year with the blocks that the data is currently tabulated with respect to.}

\item{to_year}{the year with the blocks that the data should be tabulated into.}
}
\value{
A tibble, with two sets of GEOIDs and overlap information.
}
\description{
Downloads crosswalks from \url{https://www.census.gov/geographies/reference-files/time-series/geo/relationship-files.html}.
Adjusts land overlap area to ensure weights sum to 1.
}
\examples{
pl_crosswalk("RI", 2010, 2020)

}
