% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfamily-S3methods.R,
%   R/PLNfamily-S3methods.R, R/PLNnetworkfamily-S3methods.R
\name{getModel.PLNPCAfamily}
\alias{getModel.PLNPCAfamily}
\alias{getModel}
\alias{getModel.PLNnetworkfamily}
\title{Model extraction from a collection of models}
\usage{
\method{getModel}{PLNPCAfamily}(Robject, var, index = NULL)

getModel(Robject, var, index)

\method{getModel}{PLNnetworkfamily}(Robject, var, index = NULL)
}
\arguments{
\item{Robject}{an R6 object with class PLNPCAfamily or PLNnetworkfamily}

\item{var}{value of the parameter (rank for PLNPCA, sparisty for PLNnetwork) that identifies the model to be extracted from the collection. If no exact match is found, the model with closest parameter value is returned with a warning.}

\item{index}{Integer index of the model to be returned. Only the first value is taken into account.}
}
\value{
Sends back an object with class \code{\link[=PLNPCAfit]{PLNPCAfit}} or \code{\link[=PLNPCAfit]{PLNnetworkfit}}.
}
\description{
Model extraction from a collection of models
}
\section{Methods (by class)}{
\itemize{
\item \code{PLNPCAfamily}: Model extraction for PLNPCAfamily

\item \code{PLNnetworkfamily}: Model extraction for PLNnetworkfamily
}}

\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCA <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
myModel <- getModel(myPCA, 2)
}
}
