% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfit-S3methods.R, R/PLNfit-S3methods.R,
%   R/PLNmixturefit-S3methods.R, R/PLNnetworkfit-S3methods.R
\name{standard_error.PLNPCAfit}
\alias{standard_error.PLNPCAfit}
\alias{standard_error}
\alias{standard_error.PLNfit}
\alias{standard_error.PLNfit_fixedcov}
\alias{standard_error.PLNmixturefit}
\alias{standard_error.PLNnetworkfit}
\title{Component-wise standard errors of B}
\usage{
\method{standard_error}{PLNPCAfit}(
  object,
  type = c("variational", "jackknife", "sandwich"),
  parameter = c("B", "Omega")
)

standard_error(
  object,
  type = c("sandwich", "variational", "jackknife"),
  parameter = c("B", "Omega")
)

\method{standard_error}{PLNfit}(
  object,
  type = c("sandwich", "variational", "jackknife", "bootstrap"),
  parameter = c("B", "Omega")
)

\method{standard_error}{PLNfit_fixedcov}(
  object,
  type = c("sandwich", "variational", "jackknife", "bootstrap"),
  parameter = c("B", "Omega")
)

\method{standard_error}{PLNmixturefit}(
  object,
  type = c("variational", "jackknife", "sandwich"),
  parameter = c("B", "Omega")
)

\method{standard_error}{PLNnetworkfit}(
  object,
  type = c("variational", "jackknife", "sandwich"),
  parameter = c("B", "Omega")
)
}
\arguments{
\item{object}{an R6 object with class PLNfit}

\item{type}{string describing the type of variance approximation: "variational", "jackknife", "sandwich". Default is "sandwich".}

\item{parameter}{string describing the target parameter: either B (regression coefficients) or Omega (inverse residual covariance)}
}
\value{
A p * d positive matrix (same size as \eqn{B}) with standard errors for the coefficients of \eqn{B}
}
\description{
Extracts univariate standard errors for the estimated coefficient of B. Standard errors are computed from the (approximate) Fisher information matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{standard_error(PLNPCAfit)}: Component-wise standard errors of B in \code{\link{PLNPCAfit}} (not implemented yet)

\item \code{standard_error(PLNfit)}: Component-wise standard errors of B in \code{\link{PLNfit}}

\item \code{standard_error(PLNfit_fixedcov)}: Component-wise standard errors of B in \code{\link{PLNfit_fixedcov}}

\item \code{standard_error(PLNmixturefit)}: Component-wise standard errors of B in \code{\link{PLNmixturefit}} (not implemented yet)

\item \code{standard_error(PLNnetworkfit)}: Component-wise standard errors of B in \code{\link{PLNnetworkfit}} (not implemented yet)

}}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1 + offset(log(Offset)), data = trichoptera,
              control = PLN_param(config_post = list(sandwich_var = TRUE)))
standard_error(myPLN)
}
\seealso{
\code{\link[=vcov.PLNfit]{vcov.PLNfit()}} for the complete variance covariance estimation of the coefficient
}
