% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.npTest.r
\name{plsim.npTest}
\alias{plsim.npTest}
\title{Testing nonparametric component}
\usage{
plsim.npTest(fit)
}
\arguments{
\item{fit}{the result of function \link{plsim.est} or \link{plsim.vs.soft}.}
}
\value{
A list with class "htest" containing the following components
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value for the test}
\item{method}{a character string indicating what type of test was performed}
\item{data.name}{a character string giving the name of input}
}
\description{
Study the hypothesis test:
\deqn{H_0:\eta(u) = \theta_0+\theta_1u \ \mbox{ versus }\quad H_1:\ \eta(u)\ne \theta_0 + 
\theta_1u \ \mbox{for \ some \ } u }
where \eqn{\theta_0} and \eqn{\theta_1} are unknown constant parameters.
}
\examples{

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = matrix(1,n,1)

z = matrix(runif(n*2),n,2)

y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

# Obtain parameters in PLSiM using Profile Least Squares Estimator
fit_plsimest = plsim.est(x, z, y)

res_npTest_plsimest = plsim.npTest(fit_plsimest)

# Obtain parameters in PLSiM using Penalized Profile Least Squares Estimator
# with lambda set as 0.01
fit_plsim = plsim.vs.soft(x,z,y,lambda = 0.01)

res_npTest_plsim = plsim.npTest(fit_plsim)

}
\references{
H. Liang, X. Liu, R. Li, C. L. Tsai. \emph{Estimation and testing for partially linear single-index models}.
Annals of statistics, 2010, 38(6): 3811.
}
