% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skillingsMackTest.R
\name{skillingsMackTest}
\alias{skillingsMackTest}
\alias{skillingsMackTest.default}
\title{Skillings-Mack Test}
\usage{
skillingsMackTest(y, ...)

\method{skillingsMackTest}{default}(y, groups, blocks, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Skillings-Mack rank sum test for partially balanced
incomplete block designs or partially balanced random block designs.
The null hypothesis
H\eqn{_0: \theta_i = \theta_j~~(i \ne j)} is tested against the
alternative H\eqn{_{\mathrm{A}}: \theta_i \ne \theta_j}, with at least
one inequality beeing strict.
}
\details{
The function has implemented the test of Skillings and Mack (1981).
The test statistic is assymptotically chi-squared distributed with
df = k - 1 degrees of freedom.
}
\note{
The input vector/matrix \code{'y'} must contain \code{NA}.
}
\examples{
## Example from Hollander and Wolfe 1999,
## originally appeared in Brady 1969.
x <- cbind(c(3,1,5,2,0,0,0,0),
           c(5,3,4,NA,2,2,3,2),
           c(15,18,21,6,17,10,8,13))
colnames(x) <- c("R", "A", "B")
rownames(x) <- 1:8
skillingsMackTest(x)

## Compare with Friedman Test for CRB
## Sachs, 1997, p. 675
## Six persons (block) received six different diuretics
## (A to F, treatment).
## The responses are the Na-concentration (mval)
## in the urine measured 2 hours after each treatment.
 y <- matrix(c(
3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45, 
26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
26.65),nrow=6, ncol=6, 
dimnames=list(1:6, LETTERS[1:6]))
print(y)
friedmanTest(y)
skillingsMackTest(y)
}
\references{
Skillings, J.H. and Mack, G.A. (1981) On the use of a Friedman-type
statistic in balanced and unbalanced block designs.
Technometrics. 1981; 23:171–177.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link{durbinTest}}
}
\keyword{htest}
\keyword{nonparametric}
