% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.poset.R
\name{plot.poset}
\alias{plot.poset}
\title{Plotting the Hasse diagram of a poset}
\usage{
\method{plot}{poset}(
  x,
  vertex.color = rgb(1, 1, 1, 1),
  vertex.label = x$pointer$elements(),
  vertex.label.color = rgb(0, 0, 0, 1),
  vertex.label.family = "sans",
  edge.color = rgb(0, 0, 0, 1),
  edge.label = NA,
  edge.arrow.mode = "-",
  asp = 0,
  ...,
  equispaced = FALSE,
  show = TRUE
)
}
\arguments{
\item{x}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}

\item{vertex.color}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{vertex.label}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{vertex.label.color}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{vertex.label.family}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{edge.color}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{edge.label}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{edge.arrow.mode}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{asp}{argument of the \code{plot.igraph} function, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{...}{additional plotting parameters, see \code{\link[igraph:plot.common]{igraph.plotting}} for details.}

\item{equispaced}{logical, if \code{TRUE} the nodes on the same level of the Hasse diagram are horizontally equispaced.}

\item{show}{logical, if \code{TRUE} (default) the Hasse diagram is plotted.}
}
\value{
an \code{\link[igraph:make_graph]{igraph}} object.
}
\description{
\code{plot} produces an \code{\link[igraph:make_graph]{igraph}} object and shows the Hasse diagram.
}
\details{
\code{plot.poset} computes the cover relation and produces the corresponding Directed Acyclic Graph (DAG), as an \code{\link[igraph:make_graph]{igraph}} object, returned as invisible output.
Function \code{\link[igraph]{layout_with_sugiyama}} generates the DAG layout with edges oriented from top to bottom. When \code{equispaced=TRUE}, nodes on the same Hasse diagram level are horizontally equispaced.

The Hasse diagram is displayed by a call to \code{\link[igraph]{plot.igraph}} (some default argument values are set to get a cleaner plot, by exploiting Hasse diagram properties.

Setting \code{show = FALSE} produces the \code{\link[igraph:make_graph]{igraph}} object, without showing the Hasse diagram.

Note that
}
\examples{
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)
p <- poset(x = dom)
hasse <- plot(p)
class(hasse)
}
\seealso{
\code{\link[POSetR]{poset}}, \code{\link[igraph:make_graph]{igraph}}, \code{\link[igraph:plot.common]{igraph.plotting}}
}
