% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsm.R
\name{grandparent_dsm}
\alias{grandparent_dsm}
\title{Risk-based 'Grandparent' Design Structure Matrix (DSM).}
\usage{
grandparent_dsm(S, R)
}
\arguments{
\item{S}{Resource-Task Matrix 'S' giving the links (arcs) between resources and tasks.}

\item{R}{Risk-Resource Matrix 'R' giving the links (arcs) between risks and resources.}
}
\value{
The function returns the Risk-based 'Grandparent' DSM 'G' giving the number
of risks shared between each task.
}
\description{
Risk-based 'Grandparent' Design Structure Matrix (DSM).
}
\examples{
S <- matrix(c(1, 1, 0, 0, 1, 0, 0, 1, 1), nrow = 3, ncol = 3)
R <- matrix(c(1, 1, 1, 1, 0, 0), nrow = 2, ncol = 3)
cat("Resource-Task Matrix:\n")
print(S)
cat("\nRisk-Resource Matrix:\n")
print(R)
risk_dsm <- grandparent_dsm(S, R)
cat("\nRisk-based 'Grandparent' DSM:\n")
print(risk_dsm)
}
