% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/back_test.R
\name{back_test}
\alias{back_test}
\title{Out-of-sample prediction for whole period}
\usage{
back_test(n.lag = 1:52, s.window = 52, n.history = 700, stl = TRUE,
  n.training = 156, UseGoogle = T, alpha = 1, nPred = 0,
  discount = 0.01, sepL1 = F)
}
\arguments{
\item{n.lag}{the number of lags to be used as regressor in Stage 2 of PRISM (by default = 1:52 for weekly data)}

\item{s.window}{seasonality span in seasonal decomposition (by default = 52 for weekly data)}

\item{n.history}{length of training period (e.g. in weeks) for seasonal decomposition.}

\item{stl}{if TRUE, use STL seasonal decomposition; if FALSE, use classic additive seasonal decomposition.}

\item{n.training}{length of training period in Stage 2, penalized linear regression (by default = 156)}

\item{UseGoogle}{boolean variable indicating whether to use Google Trend data.}

\item{alpha}{penalty between lasso and ridge. alpha=1 represents lasso, alpha=0 represents ridge, alpha=NA represents no penalty (by default alpha = 1).}

\item{nPred}{the number of periods ahead for forecast. nPred = 0,1,2,3.}

\item{discount}{exponential weighting: (1-discount)^lag.}

\item{sepL1}{if TRUE, use separate L1 regularization parameters for time series components and exogenous variables (Goolgle Trend data)}
}
\value{
\code{prediction} \code{nPred} week ahead prediction of the whole periods (07 - 16).
}
\description{
Out-of-sample prediction for whole period
}
\examples{
claim_data = load_claim_data()

\donttest{# It may take a few minutes.}
\donttest{prism_prediction = back_test()}
\donttest{# evaluate the out-of-sample prediction error as a ratio to naive method}
\donttest{evaluation_table(claim_data, prism_prediction)}

}
