% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking_functions.R
\name{runCalibration}
\alias{runCalibration}
\title{Run Calibration}
\usage{
runCalibration(data, fixedpar = FALSE, ignore_nonconv = FALSE, ...)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{fixedpar}{if \code{TRUE} (default), perform fixed parameter calibration using anchor data.}

\item{ignore_nonconv}{if \code{TRUE}, return results even when calibration did not converge. Defaults to \code{FALSE}.}

\item{...}{additional arguments to pass onto \code{\link[mirt]{mirt}} in \href{https://CRAN.R-project.org/package=mirt}{'mirt'} package.}
}
\value{
\code{\link{runCalibration}} returns a \code{\linkS4class{SingleGroupClass}} object containing item calibration results.

This object can be used in \code{\link[mirt:coef-method]{coef}}, \code{\link[mirt]{itemfit}}, \code{\link[mirt]{itemplot}} in \href{https://CRAN.R-project.org/package=mirt}{'mirt'} package to extract wanted information.
}
\description{
\code{\link{runCalibration}} is a function to perform item calibration on the response data.
}
\examples{
\dontrun{
out_calib <- runCalibration(data_asq) # errors
}
\donttest{
out_calib <- runCalibration(data_asq, technical = list(NCYCLES = 1000))

mirt::coef(out_calib, IRTpars = TRUE, simplify = TRUE)
mirt::itemfit(out_calib, empirical.plot = 1)
mirt::itemplot(out_calib, item = 1, type = "info")
mirt::itemfit(out_calib, "S_X2", na.rm = TRUE)
}
}
