% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS_PGx_CT.R
\name{PRS_PGx_CT}
\alias{PRS_PGx_CT}
\title{Construct PGx PRS unadjusted or using clumping and thresholding}
\usage{
PRS_PGx_CT(
  PGx_GWAS,
  G_reference,
  pcutoff = 1e-04,
  clumping = TRUE,
  p1 = 1e-04,
  d1 = 250000,
  r1 = 0.8
)
}
\arguments{
\item{PGx_GWAS}{a numeric matrix containing PGx GWAS summary statistics, including SNP ID, MAF, position, \eqn{\beta}, \eqn{\alpha}, 2-df p-value, and N}

\item{G_reference}{a numeric matrix containing the individual-level genotype information from the reference panel (e.g., 1KG)}

\item{pcutoff}{a numeric value indicating the p-value cutoff}

\item{clumping}{a logical flag indicating should clumping be performed}

\item{p1}{a numeric value indicating p-value threshold to decide flag SNPs in clumping}

\item{d1}{a numeric value indicating window size in clumping}

\item{r1}{a numeric value indicating correlation in clumping}
}
\value{
A numeric list, the first sublist contains estimated prognostic effect sizes, the second sublist contains estimated predictive effect sizes, the third sublist contains 2-df p-values
}
\description{
Shrink prognostic and predictive effect sizes simutaneously by 2-df (main and interaction) p-value cutoff (PRS-PGx-CT turns out to be PRS-PGx-Unadj when setting p-value cutoff = 1)
}
\details{
PRS-PGx-CT only needs PGx summary statistics
}
\examples{
data(PRSPGx.example); attach(PRSPGx.example)
coef_est <- PRS_PGx_CT(PGx_GWAS, G_reference, pcutoff = 0.01, clumping = TRUE)
summary(coef_est$coef.G)
summary(coef_est$coef.TG)

}
\references{
Zhai, S., Zhang, H., Mehrotra, D.V. & Shen, J. Paradigm Shift from Disease PRS to PGx PRS for Drug Response Prediction using PRS-PGx Methods (submitted).
}
\author{
Song Zhai
}
