#' @title Non agricultural establishments data from Pakistan Social and Living Standards Measurement 2015-16 
#' @name   NonAgriculture
#' @docType data
#' @keywords datasets
#' @usage data(NonAgriculture)
#' @description \code{NonAgriculture} Non agricultural establishments data from Pakistan Social and Living Standards Measurement 2015-16.
#' @format A \code{data.table} and  \code{data.frame} with 115628 obs. of  13 variables.
#' \describe{
#'        \item{\code{hhcode}}{10 digits Household code.}
#'        \item{\code{Province}}{Province of Pakistan}
#'        \item{\code{Region}}{Urban or Rural area of Pakitan}
#'        \item{\code{Psu}}{08 digits code of primary sampling unit}
#'        \item{\code{sec}}{Questionair section}
#'        \item{\code{industrycode}}{Industrial type}
#'        \item{\code{idc}}{Identity code of a person}
#'        \item{\code{snoestab}}{}
#'        \item{\code{Codes}}{Industrial income and expenditure sources}
#'        \item{\code{S8a}}{Direct mix response from respondent}
#'        \item{\code{S8b}}{Direct mix response from respondent}
#'        \item{\code{S8c}}{Direct mix response from respondent}
#'        \item{\code{S8d}}{Direct mix response from respondent}
#'        }
#' @author Muhammad Yaseen (\email{myaseen208@gmail.com})
#' @author Muhammad Arfan Dilber (\email{pbsfsd041@gmail.com})
#' 
#' @references \enumerate{
#' \item Pakistan Bureau of Statistics, Micro data (\url{http://www.pbs.gov.pk/}).
#'  }
#'
#' @seealso 
#'    \code{\link{Agriculture}}
#'  , \code{\link{AssetLiability}}
#'  , \code{\link{Education}}
#'  , \code{\link{Employment}}
#'  , \code{\link{Expenditure}}
#'  , \code{\link{ICT}}
#'  , \code{\link{Income}}
#'  , \code{\link{Land}}
#'  , \code{\link{LiveStock}}
#'  , \code{\link{OtherIncome}}
#'  , \code{\link{PaidReceived}}
#'  , \code{\link{SurveyInfo}}
NULL