% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillanalysis.R
\name{hillanalysis}
\alias{hillanalysis}
\title{Hill Isotherm Non-Linear Analysis}
\usage{
hillanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for the Hill isotherm, and model
error analysis
}
\description{
Hill isotherm model shows the connection of different species
being adsorbed on to the homogeneous surfaces. This isotherm model supposes
that adsorption is a cooperative phenomenon which means the adsorbates having
the capability to bind at one specific site on the adsorbent affecting other
binding sites on the same adsorbent
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
hillanalysis(Ce,Qe)
}
\references{
Hill, T. L. (1946) <doi:10.1063/1.1724129> "Statistical mechanics of multimolecular
adsorption II. Localized and mobile adsorption and absorption," The Journal
of Chemical Physics, vol. 14, no. 7, pp. 441-453.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
