% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/langmuir3LM.R
\name{langmuir3.LM}
\alias{langmuir3.LM}
\title{Langmuir Isotherm Third Linear Form Analysis}
\usage{
langmuir3.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the parameters for the Langmuir isotherm (third form), model error analysis,
and linear regression analysis
}
\description{
The Langmuir adsorption isotherm is used to
describe the equilibrium between adsorbate and adsorbent
system, where the adsorbate adsorption is limited to one
molecular layer at or before a relative pressure of unity is reached.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
langmuir3.LM(Ce,Qe)
}
\references{
Langmuir, I. (1918). <doi:/10.1021/ja01269a066> The adsorption of
gases on plane surfaces of glass, mics and platinum. Journal of the American
Chemical Society, 1361-1403.

Chen, X. (2015) <doi:/10.3390/info6010014> Modeling of Experimental
Adsorption Isotherm Data. 14-22.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
