% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aksummary.l.R
\name{aksummary.l}
\alias{aksummary.l}
\title{Linear Adsorption Kinetic Model Summary}
\usage{
aksummary.l(t, qt, qe, sort.by)
}
\arguments{
\item{t}{the numerical value for contact time. This parameter should not be equal to zero to prevent infinite value. Any row(s) that contain(s) value of t equal to zero will be automatically removed to proceed with the calculation.}

\item{qt}{the numerical value for the amount adsorbed at time t. This parameter should not be equal to qe or zero as it will cause an infinite value. Any row(s) that contain(s) value of qt equal to qe or zero will be automatically removed to proceed with the calculation.}

\item{qe}{the numerical value for the amount adsorbed at equilibrium}

\item{sort.by}{the name of the statistical error parameter in which the models are sorted in either increasing or decreasing order. The only accepted arguments are "RMSE" for Relative Mean Square Error, 'MAE' for Mean Absolute Error, 'MSE' for Mean Squared Error, 'RAE' for Relative Absolute Error, 'AIC' for Akaike Information Criterion, 'BIC' for Bayesian Information Criterion, 'R2' for Coefficient of Determination, and 'SE' for Standard Error Estimate. This argument is case-sensitive, and failure to input the correct value will yield a summary of models in alphabetical order.}
}
\value{
the summarized error and parameter values from adsorption kinetic models.
}
\description{
Summarized results of parameter and error values collected from linear adsorption kinetic models, namely: Elovich, Fractional Power, Pseudo-First-Order, and Pseudo-Second-Order.
}
\examples{
t  <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.8
aksummary.l(t,qt,qe,"R2")
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
