% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_fun.R
\name{mbm_resample}
\alias{mbm_resample}
\title{Dataframe resample function}
\usage{
mbm_resample(df, fraction, by)
}
\arguments{
\item{df}{dataframe}

\item{fraction}{fraction of data to resample from dataframe}

\item{by}{timescale over which to resample, day, week, or month}
}
\value{
Returns randomly resampled dataframe
}
\description{
This function resamples data from a given dataframe.
Dataframe must have columns created through plr_cleaning to denote time segments
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
dfc_resampled <- mbm_resample(test_dfc, fraction = 0.65, by = "week")

}
