% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_quality.R
\name{data_quality_check}
\alias{data_quality_check}
\title{checks the quality of the data after and before cleaning}
\usage{
data_quality_check(
  energy_data,
  col = "elec_cons",
  id = "pv_df",
  batch_days = 90
)
}
\arguments{
\item{energy_data}{structured energy dataframe}

\item{col}{Input column}

\item{id}{PV system ID}

\item{batch_days}{the batch of data that the anomaly detection is applied. Since time series decomposition is used,
one seasonality will be applied for whole data which is inefficient, if NA, will pass whole}
}
\value{
a table with grading of the quality after and before cleaning
}
\description{
calculates the percentage of anomalies, missings + zeros, gaps, and length of
the data and reports the quality of data before and after cleaning.
}
\details{
The quality grading criteria is as following:
anomalies A: less than 10%, B: 10 to 20%, C: 20 to 30%, D: more than 30%
missing percentage: A: less than 10%, B: 10 to 15%, C: 15 to 20% and D: more than 20%
largest gap: A: less than 120 hours, B: 120 to 164 hours, C: 164 to 240 hours
D: more than 240 hours
length P: more than 2 years, F: less than 2 years
}
\author{
Arash Khalilnejad
}
