% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_performance.R
\name{monitor_performance}
\alias{monitor_performance}
\title{Calculate Monitor Prediction Performance}
\usage{
monitor_performance(predicted, observed, t1, t2, metric = NULL,
  FPCost = 1, FNCost = 1)
}
\arguments{
\item{predicted}{ws_monitor object with predicted data}

\item{observed}{ws_monitor object with observed data}

\item{t1}{value used to classify \code{predicted} measurements}

\item{t2}{threshold used to classify \code{observed} measurements}

\item{metric}{\emph{confusion matrix} metric to be used}

\item{FPCost}{cost associated with false positives (type II error)}

\item{FNCost}{cost associated with false negatives (type I error)}
}
\value{
Dataframe of monitors vs named measure of performance.
}
\description{
This function uses \emph{confusion matrix} analysis to calculate
different measures of predictive performance for every timeseries found
in \code{predicted} with respect to the observed values found in the single timeseries
found in \code{observed}.

The requested metric is returned in a dataframe organized with one row per monitor,
all available metrics are returned.
}
\examples{
\dontrun{
# If daily avg data were the prediciton and Spokane were
# the observed, which WA State monitors had skill?
wa <- airnow_load(2017) \%>\% monitor_subset(stateCodes='WA')
wa_dailyAvg <- monitor_dailyStatistic(wa, mean)
Spokane_dailyAvg <- monitor_subset(wa_dailyAvg, monitorIDs='530630021_01')
threshold <- AQI$breaks_24[4] # Unhealthy
performanceMetrics <- monitor_performance(wa_dailyAvg,
                                          Spokane_dailyAvg,
                                          threshold, threshold)
monitorIDs <- rownames(performanceMetrics)
mask <- performanceMetrics$heidikeSkill &
        !is.na(performanceMetrics$heidikeSkill)
skillfulIDs <- monitorIDs[mask]
skillful <- monitor_subset(wa_dailyAvg, monitorIDs=skillfulIDs)
monitorLeaflet(skillful)
}
}
\seealso{
\link{monitorMap_performance}

\link{skill_confusionMatrix}
}
\keyword{ws_monitor}
