% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadDataFile.R
\name{downloadDataFile}
\alias{downloadDataFile}
\title{Download data from URL to local diredctory}
\usage{
downloadDataFile(filename = NULL, baseUrl = NULL,
  dataDir = "~/data/monitoring/RData", ...)
}
\arguments{
\item{filename}{Name of the data file to be loaded.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory in which to save the data file.}

\item{...}{Additional arguments passed to \code{download.file}.}
}
\value{
A \emph{ws_monitor} object.
}
\description{
Downloads a data file into \code{dataDir} for later use.
Downloaded versions of PWFSL monitoring .RData files allow users to work with
the package without access to the internet. Once data are downloaded to
\code{dataDir}, any of the data loading functions can be called with the
\code{dataDir} argument to replace internet downloads with local file access.

The recommended directory for PWFSL monitoring data is
\code{"~/data/monitoring/RData"}.
}
\keyword{internal}
