% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_obj.R
\name{print.matched.set}
\alias{print.matched.set}
\title{Print matched.set objects.}
\usage{
\method{print}{matched.set}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{a \code{matched.set} object}

\item{...}{Not used. additional arguments to be passed to \code{print}}

\item{verbose}{logical indicating whether or not output should be printed in expanded/raw list form.
The verbose form is not recommended unless the data set is small. Default is FALSE, which prints an overview of matched set sizes.}
}
\description{
Print matched.set objects.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4,
                        refinement.method = "ps.match",
                        match.missing = TRUE,
                        covs.formula = ~ tradewb,
                        size.match = 5, qoi = "att",
                        lead = 0:4,
                        forbid.treatment.reversal = FALSE)
print(extract(PM.results, qoi = "att"))



}
