% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_PDF}
\alias{Pareto_PDF}
\title{Density of the Pareto Distribution}
\usage{
Pareto_PDF(x, t, alpha, truncation = NULL)
}
\arguments{
\item{x}{Numeric. The function evaluates the density at \code{x}}

\item{t}{Numeric. Threshold of the Pareto distribution.}

\item{alpha}{Numeric. Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
Density function of the Pareto distribution with parameters \code{t} and \code{alpha} evaluated at \code{x}
}
\description{
Calculates the density function of the Pareto distribution. This function is deprecated. Use \code{dPareto} instead.
}
\examples{
x <- 0:10 * 1000
dPareto(x, 1000, 2)
dPareto(x, 1000, 2, truncation = 5000)

}
