% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{weibullDecay}
\alias{weibullDecay}
\title{Weibull decay function.}
\usage{
weibullDecay(x, signal, decay = 0.999, shape = 1.05)
}
\arguments{
\item{x}{A numeric vector of distances (in [0,1]).}

\item{signal}{A single numeric value representing a signal.}

\item{decay}{The rate (in [0,1]) at which the signal decays.
This term indicates how much the \code{signal} decreases at a certain
distance in \code{x}. At the distance defined by the \code{pdist} term
(see \code{\link{circularProjection}}), the signal's value will
correspond to the initial signal multiplied by \code{1 - decay}.}

\item{shape}{A parameter (>=1) of a Weibull function. When \code{shape=1}
the Weibull decay follows an exponential decay. When \code{shape>1}
the function is first convex, then concave with an inflection point.}
}
\value{
A numeric vector.
}
\description{
The \code{weibullDecay} function is used by
PathwaySpace's methods for signal convolution and projection.
}
\examples{
x <- c(1:100) / 100
y <- weibullDecay(x, 1)
plot(x, y)

}
\seealso{
\code{\link{expDecay}}, \code{\link{linearDecay}}
}
\author{
Vinicius Chagas, Victor Apolonio, and
Mauro Castro (\email{mauro.castro@ufpr.br})
}
