% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway-vote.R
\name{pathway_vote}
\alias{pathway_vote}
\title{Pathway Vote Algorithm for eQTM Data (Auto Parallel)}
\usage{
pathway_vote(
  ewas_data,
  eQTM,
  k_values,
  stat_grid,
  distance_grid,
  overlap_threshold,
  databases = c("Reactome"),
  rank_column = "p_value",
  rank_decreasing = FALSE,
  use_abs = FALSE,
  prune_strategy = "cuberoot",
  fixed_value = 3,
  min_genes_per_hit = 3,
  readable = FALSE,
  workers = NULL,
  verbose = FALSE
)
}
\arguments{
\item{ewas_data}{A data.frame with columns: cpg and a ranking column (e.g., p_value, score).}

\item{eQTM}{An eQTM object containing eQTM data.}

\item{k_values}{A numeric vector of top k CpGs to select (e.g., c(10, 50, 100)).}

\item{stat_grid}{A numeric vector of statistics thresholds.}

\item{distance_grid}{A numeric vector of distance thresholds.}

\item{overlap_threshold}{A numeric value for gene list overlap threshold.}

\item{databases}{A character vector of pathway databases (e.g., "Reactome").}

\item{rank_column}{A character string indicating which column in `ewas_data` to use for ranking.}

\item{rank_decreasing}{Logical. If TRUE (default), sorts CpGs from high to low based on `rank_column`.}

\item{use_abs}{Logical. Whether to apply `abs()` to the ranking column before sorting CpGs.}

\item{prune_strategy}{Character, either "cuberoot" or "fixed". If "cuberoot", the minimum vote support is computed as (N)^(1/3) where N is the number of enrichment combinations. If "fixed", uses the value provided by `fixed_value`.}

\item{fixed_value}{Integer, used only if `prune_strategy = "fixed"`.}

\item{min_genes_per_hit}{Minimum number of genes (`Count`) a pathway must include to be considered.}

\item{readable}{Logical. whether to convert Entrez IDs to gene symbols in enrichment results.}

\item{workers}{Optional integer. Number of parallel workers. If NULL, use 2 logical cores by default.}

\item{verbose}{Logical. whether to print progress messages.}
}
\value{
A named list of data.frames, each containing enrichment results (pathway ID, p.adjust, Description, geneID) for one database (e.g., Reactome, KEGG).
}
\description{
Performs pathway enrichment analysis using a voting-based approach on eQTM data.
}
\examples{
data <- data.frame(
  cpg = c("cg000001", "cg000002", "cg000003"),
  statistics = c(2.5, -1.8, 3.2),
  p_value = c(0.01, 0.03, 0.005),
  distance = c(50000, 80000, 30000),
  entrez = c("673", "1956", "5290")
)
eqtm_obj <- create_eQTM(data)
\donttest{
results <- pathway_vote(
  ewas_data = data,
  eQTM = eqtm_obj,
  k_values = c(2),
  stat_grid = c(1.5),
  distance_grid = c(1e5),
  overlap_threshold = 0.3,
  databases = c("KEGG"),
  rank_column = "p_value",
  rank_decreasing = FALSE,
  use_abs = FALSE,
  worker = 1, # If not specified, will use 2 cores by default
  verbose = FALSE
)
}

}
