% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addFutureObservationQuery}
\alias{addFutureObservationQuery}
\title{Query to add the number of days till the end of the observation period at a
certain date}
\usage{
addFutureObservationQuery(
  x,
  indexDate = "cohort_start_date",
  futureObservationName = "future_observation",
  futureObservationType = "days"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the future
observation.}

\item{futureObservationName}{name of the new column to be added.}

\item{futureObservationType}{Whether to return a "date" or the number of
"days".}
}
\value{
cohort table with added column containing future observation of the
individuals.
}
\description{
`r lifecycle::badge("experimental")`
Same as `addFutureObservation()`, except query is not computed to a table.
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addFutureObservationQuery()
mockDisconnect(cdm = cdm)
}
}
