% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{evolution,network-method}
\alias{evolution,network-method}
\alias{evolution}
\alias{evolution-methods}
\title{See the evolution of the network with change of cutoff}
\usage{
\S4method{evolution}{network}(
  net,
  list_nv,
  gr = NULL,
  color.vertex = NULL,
  color.edge = NULL,
  fix = TRUE,
  size = c(2000, 1000),
  label_v = 1:dim(net@network)[1],
  legend.position = "topleft",
  frame.color = "black",
  label.hub = FALSE,
  outdir,
  type.ani = "html"
)
}
\arguments{
\item{net}{a network object}

\item{list_nv}{a vector of cutoff at which the network should be shown}

\item{gr}{a vector giving the group of each genee. Defaults to NULL}

\item{color.vertex}{a vector giving the color of each nodee. Defaults to NULL}

\item{color.edge}{a vector giving the color of each edge. Defaults to NULL}

\item{fix}{logical, should the position of the node in the network be calculated once at the beginning ? Defaults to TRUE.}

\item{size}{vector giving the size of the plot. Defaults to c(2000,1000)}

\item{label_v}{vector giving the labels of each vertex. Defaults to 1:dim(net@network)[1]}

\item{legend.position}{string giving the position of the legend. Defaults to "topleft"}

\item{frame.color}{string giving the color of the frame of the plot. Defaults to "black"}

\item{label.hub}{label hubs. Defaults to FALSE}

\item{outdir}{Directory to save the animation. No default value since it must be specified by the user.}

\item{type.ani}{Type of animation. Defaults to "html"}

\item{legend}{string giving the position of the legend. Defaults to "topleft"}
}
\value{
A HTML page with the evolution of the network.
}
\description{
See the evolution of the network with change of cutoff
}
\details{
Several types of outputs are available using the type.ani option. \itemize{
\item html \item latex (requires latex) \item swf (requires swftools)
\item video (requires ffmpeg) \item gif \item manual_gif }
}
\examples{

\donttest{
data(network)
sequence<-seq(0,0.2,length.out=20)

#Change the destdir to have the animation created where you want. 
destdir = tempdir()

#Example of use of the evolution method with an html output.
evolution(network,sequence,type.ani = "html",outdir=destdir)

#Example of use of the evolution method with an animated gif output.
evolution(network,sequence,type.ani = "gif",outdir=destdir)
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{methods}
