% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_TL_simulate.R
\name{LP_TL_simulate}
\alias{LP_TL_simulate}
\title{Simulate data from a Lincoln-Petersen Model with Tag Loss}
\usage{
LP_TL_simulate(
  dt_type = NULL,
  N = 1000,
  cov1 = function(N) {
     rep(1, N)
 },
  cov2 = function(cov1) {
     rep(1, length(cov1))
 },
  p1 = function(cov1, cov2) {
     rep(0.1, length(cov1))
 },
  pST = function(cov1, cov2) {
     rep(0.5, length(cov1))
 },
  pST.1 = function(cov1, cov2) {
     rep(1, length(cov1))
 },
  rho1 = function(cov1, cov2) {
     rep(0.8, length(cov1))
 },
  rho2 = function(cov1, cov2) {
     rep(0.8, length(cov1))
 },
  p2 = function(cov1, cov2) {
     rep(0.1, length(cov1))
 },
  seed = round(1e+08 * runif(1)),
  trace = FALSE
)
}
\arguments{
\item{dt_type}{Double Tag type. Valid values are
\code{notD}, \code{twoD}, and \code{t2perm}
for two indistinguishable tags; two distinguishable tags, when the second tag is a permanent tag and cannot be lost,
respectively.}

\item{N}{Population size}

\item{cov1}{Function to generate first covariate for each member of population as function of \code{N}}

\item{cov2}{Function to generate second covariate for each member of population as function of \code{cov1}.}

\item{p1}{Function to generate P(capture) at event 1 for each member of population as function of \code{cov1,cov2}.}

\item{pST}{Function to generate P(single tag) if captured at event 1 as function of \code{cov1,cov2}.}

\item{pST.1}{Function to generate p(apply single tag to first position at event 1) as function of \code{cov1,cov2}.}

\item{rho1}{Function to generate P(tag1 retained) as function of \code{cov1,cov2}.}

\item{rho2}{Function to generate P(tag2 retained) as function of \code{cov1,cov2}.}

\item{p2}{Function to generate P(capture) at event 2 for each member of population as function of \code{cov1,cov2}.}

\item{seed}{Initial value of random seed}

\item{trace}{Trace flag to help debug if things fail.}
}
\value{
Data frame with observed capture histories
}
\description{
This function creates simulated capture histories for the Lincoln-Petersen
model with tag loss.
}
\details{
The \code{cov1} function takes the value \code{N} and returns N covariate values. For example these could be
simulated length, or sex of each fish. The \code{cov2} function takes the \code{cov1} values and generates
a second covariate. Two covariates should be sufficient for most capture-recapture simulations.
If generating continuous covariates, you should round the covariate to
about 100 distinct values to speed up your simulation.

The remaining functions take the two covariate values and generate capture probabilities, single tag probabilities,
placing tags on fish, and tag retention probabilities. These should all be in the range of 0 to 1.

After generating capture histories for the entire population, animals never seen are "discarded" and the
data set is compress to unique combinations of the two covariates and the capture history with the frequency
variable set accordingly.
}
\examples{

sim_data <-LP_TL_simulate(
      dt_type="t2perm",  # permanent tag
      N=1000,
      cov1=function(N)         {rep(1,N)},
      cov2=function(cov1)      {rep(1,  length(cov1))},
      p1  =function(cov1, cov2){rep(.1, length(cov1))},
      pST =function(cov1, cov2){rep(.25,length(cov1))},
      rho1=function(cov1, cov2){rep(.70,length(cov1))},
      rho2=function(cov1, cov2){rep(1,  length(cov1))},  # permanent second tag
      p2  =function(cov1, cov2){rep(.1, length(cov1))},
      seed=round(1000000*runif(1)))
sim_data

}
