% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_SPAS_est.R
\name{LP_SPAS_est}
\alias{LP_SPAS_est}
\title{Extract estimates of abundance after SPAS fit}
\usage{
LP_SPAS_est(LP_SPAS_fit, conf_level = 0.95, trace = FALSE)
}
\arguments{
\item{LP_SPAS_fit}{A result of an call to fitting at SPAS object.}

\item{conf_level}{The expected coverage for confidence intervals on N.}

\item{trace}{If trace flag is set in call when estimating functions}
}
\value{
An list object with abundance estimates and other information with the following elements
\itemize{
\item \strong{summary} Data frame with abundance estimates, their SE, and CIs as requested
\item \strong{datetime} Date and time the estimation was done from the fit.
}
}
\description{
This will take a previous fit and return estimates of abundance.
}
\examples{

data(data_spas_harrison)
fit <- Petersen::LP_SPAS_fit(data=data_spas_harrison,
                              model.id="Pooling rows 5/6",
                              row.pool.in=c(1,2,3,4,56,56),
                              col.pool.in=c(1,2,3,4,5,6))
fit$summary
est <- Petersen::LP_SPAS_est(fit)
est$summary
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
