% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summarizeSensitivityPhenotype.R
\name{summarizeSensitivityPhenotype}
\alias{summarizeSensitivityPhenotype}
\title{Takes the sensitivity data from a PharmacoSet, and summarises them into a
drug vs cell line table}
\usage{
summarizeSensitivityPhenotype(pSet, sensitivity.measure = c("ic50_published",
  "auc_published", "ic50_recompted", "auc_recomputed"),
  summaryStat = c("median", "mean", "first", "last"))
}
\arguments{
\item{pSet}{[PharmacoSet] The PharmacoSet from which to extract the data}

\item{sensitivity.measure}{[character] which sensitivity sensitivity.measure to use? The current
choices are 'ic50_published', 'auc_published', 'ic50_recomputed',
'auc_recomputed'.}

\item{summaryStat}{[character] which summaryStat method to use if there are repeated
pairs of cells and drugs?}
}
\value{
[matrix] A matrix with cell lines going down the rows, drugs across
  the columns, with the selected sensitivity statistic for each pair.
}
\description{
This function creates a table with cell lines as rows and drugs as columns,
summarising the drug senstitivity data of a PharmacoSet into drug-cell line
pairs
}
\examples{
data(CGPsmall)
CGPauc <- summarizeSensitivityPhenotype(CGPsmall, sensitivity.measure='auc_published')
}

