\name{readPhySim.tree}
\alias{readPhySim.tree}
\title{Read Tree File in Parenthetic Format}
\usage{
readPhySim.tree(file = "", format = "Newick", rooted = TRUE, text = NULL,
          tree.names = NULL, skip = 0, comment.char = "#", ...)
}
\arguments{
  \item{file}{a file name specified by either a variable of mode character,
    or a double-quoted string; if \code{file = ""} (the default) then the
    tree is input on the keyboard, the entry being terminated with a
    blank line.}
  \item{format}{a character giving the format of the tree file; by
    default \code{"Newick"}. Currently only the Newick format is
    available to read trees in Nexus
    files).}
  \item{rooted}{a logical indicating whether the tree is rooted or not;
    defaults to \code{TRUE}. This is currently not implemented, meaning
    that all trees are read as rooted.}
  \item{text}{alternatively, the name of a variable of mode character
    which contains the tree(s) in parenthetic format. By default, this
    is ignored (set to \code{NULL}, meaning that the tree is read in a
    file); if \code{text} is not \code{NULL}, then the argument
    \code{file} is ignored.}
  \item{tree.names}{if there are several trees to be read, a vector of
    mode character that gives names to the individual trees; if
    \code{NULL} (the default), the trees are named \code{"tree1"},
    \code{"tree2"}, ...}
  \item{skip}{the number of lines of the input file to skip before
    beginning to read data (this is passed directly to\code{ scan()}).}
  \item{comment.char}{a single character, the remaining of the line
    after this character is ignored (this is passed directly to
    \code{scan()}).}
  \item{...}{Further arguments to be passed to \code{scan()}.}
}
\description{
  This function reads a file which contains one or several trees in
  parenthetic format known as the Newick or New Hampshire format.
}
\details{
  The default option for \code{file} allows to type directly the tree on
  the keyboard (or possibly to copy from an editor and paste in R's
  console) with, e.g., \code{mytree <- read.tree()}.

  `read.tree' tries to represent correctly trees with a badly
  represented root edge (i.e. with an extra pair of parentheses). For
  instance, the tree "((A:1,B:1):10);" will be read like "(A:1,B:1):10;"
  but a warning message will be issued in the former case as this is
  apparently not a valid Newick format. If there are two root edges
  (e.g., "(((A:1,B:1):10):10);"), then the tree is not read and an error
  message is issued.
}
\note{
phylogenetic tree information in PhySim is stored in objects of class phylo compatible with old versions of APE (<=1.8-4) but in a format no longer usable by that program. In order to read in phylogenetic trees generated by APE into PhySim first write the tree using APE function write.tree and then read the tree into PhySim using readPhySim.tree.

readPhySim.tree and this help file are derived from read.tree and its helpfile obtained from old versions of the package APE (<=1.8-4) by Emmanuel Paradis.
}

\author{Emmanuel Paradis wrote the original code}
\seealso{\code{\link{writePhySim.tree}}, to write a phylogenetic tree to a file}
\keyword{manip}
\keyword{IO}
