\name{db.Rcrossprod-class}
\Rdversion{1.1}
\docType{class}
\alias{db.Rcrossprod-class}

\title{Class \code{"db.Rcrossprod"}}
\description{
  This is the result generated by \code{\link{crossprod}}, and a
  sub-class of \code{\linkS4class{db.Rquery}}
}

\section{Slots}{
  As a sub-class of \code{\linkS4class{db.Rquery}}, this class contains
  all the slots that belong to \code{\linkS4class{db.Rquery}}. It also
  has one additional slot as is described in the following.

  \describe{
    \item{\code{.is.crossprod}:}{
      A vector of logical values, which has the same length as the
    number of columns. Whether each column is the result of
    \code{\link{crossprod}}.
  }
  \item{\code{.is.symmetric}:}{
    A vector of logical values, which has the same length as the
    number of columns. Whether the column contains matrices that are
    symmetric.
  }
    \item{\code{.dim}:}{
        Dimension of the matrix represented by this object.
    }
  }
}

\section{Extends}{
Class \code{"\linkS4class{db.Rquery}"}, directly.
}

\section{Methods}{
All methods for \code{\linkS4class{db.data.frame}} can be applied onto
this class.
}

\author{
  Author: Predictive Analytics Team at Pivotal Inc.

  Maintainer: Frank McQuillan, Pivotal Inc. \email{fmcquillan@pivotal.io}
}

\seealso{
  \code{\linkS4class{db.Rquery}} is the superclass.

  \code{\link{lk}} or \code{\link{lookat}} display the matrix
}

\examples{
\dontrun{
showClass("db.Rcrossprod")

%% @test .port Database port number
%% @test .dbname Database name
## set up the database connection
## Assume that .port is port number and .dbname is the database name
cid <- db.connect(port = .port, dbname = .dbname, verbose = FALSE)

## x points to table "abalone"
x <- as.db.data.frame(abalone, conn.id = cid, verbose = FALSE)

lookat(crossprod(x[,-c(1,2)]))

x$arr <- db.array(1, x$length, x$diameter)

lookat(crossprod(x$arr))

db.disconnect(cid, verbose = FALSE)
}
}

\keyword{classes}
\keyword{database}
