% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_overlap_heatmap.R
\name{VDJ_overlap_heatmap}
\alias{VDJ_overlap_heatmap}
\title{Wrapper to determine and plot overlap between VDJ features across groups}
\usage{
VDJ_overlap_heatmap(
  VDJ,
  feature.columns,
  grouping.column,
  jaccard,
  plot.type,
  pvalues.label.size,
  axis.label.size,
  add.barcode.table
)
}
\arguments{
\item{VDJ}{VDJ output of the VDJ_GEX_matrix function (VDJ_GEX_matrix.output[[1]])}

\item{feature.columns}{A character array of column names of which the overlap should be displayed. The content of these columns is pasted together (separated by "/"). E.g. if the overlap in cells germline gene usage is desired, the input could be c("VDJ_jgene","VDJ_dgene","VDJ_vgene"). These columns would be pasted and compared across the grouping variable.}

\item{grouping.column}{A column which acts as a grouping variable. If repertoires are to be compared use the sample_id column.}

\item{jaccard}{Boolean. Defaults to FALSE. If set to TRUE, the overlap will be reported as jaccard index. If set to FALSE the overlap will be repored as absolute counts}

\item{plot.type}{Character. Either "ggplot" or "pheatmap". Defaults to Pheatmap}

\item{pvalues.label.size}{Numeric. Defaults to 4. Is passed on to ggplot theme}

\item{axis.label.size}{Numeric. Defaults to 4. Is passed on to ggplot theme}

\item{add.barcode.table}{Boolean. Defaults to T. Whether to generate a dataframe with frequencies and barcodes of cells with overlapping features. This is useful to e.g. analyze deferentially expressed genes between cells of two samples or groups expressing the same VDJ or VJ chain}
}
\value{
A list of a ggplot (out[[1]]), the source table or matrix for the plot out[[2]] and a table containing additional information in case that add.barcode.table was set to TRUE (out[[3]])
}
\description{
Yields overlap heatmap and datatable of features or combined features for different samples or groups
}
\examples{
#To test the overlap of CDR3s between multiple samples
overlap <- VDJ_overlap_heatmap(VDJ = Platypus::small_vgm[[1]]
,feature.columns = c("VDJ_cdr3s_aa"),
grouping.column = "sample_id", axis.label.size = 15
, plot.type = "ggplot")

}
