% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_nb_SHM_compare_to_germline_plot.R
\name{Spatial_nb_SHM_compare_to_germline_plot}
\alias{Spatial_nb_SHM_compare_to_germline_plot}
\title{Plotting number of somatic hypermutation of clones compare to the germline sequence of the clonotype.}
\usage{
Spatial_nb_SHM_compare_to_germline_plot(
  simulation = c(TRUE, FALSE),
  vgm_VDJ,
  AbForest_output,
  nb_clonotype,
  simulated_VDJ,
  sample_names,
  bcs_merge,
  images_tibble,
  title,
  size,
  legend_title
)
}
\arguments{
\item{simulation}{Logical operator, to describe which type of data we want to plot, TRUE if the data are output of Echidna simulation and FALSE if the we use real dataset.}

\item{vgm_VDJ}{Data frame containing cell of interest and x and y coordinates and GEX_barcode.}

\item{AbForest_output}{Igraph of phylogenetic tree of a clonotype of interest found in the large list output from AntibodyForest function, only needed if we use real dataset.}

\item{nb_clonotype}{Numeric, value which designates the clonotype we want to study if we use simulated data (Echidna output).}

\item{simulated_VDJ}{Large list, output of Echidna simulate_repertoire function. Only needed if we use simulated data.}

\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{legend_title}{Character vector to name the legend scale.}
}
\value{
Spatial plot with cells colored by number of somatic hypermutation
}
\description{
Plotting number of somatic hypermutation of clones compare to the germline sequence of the clonotype.
}
\examples{
\dontrun{
Spatial_nb_SHM_compare_to_germline_plot(simulation = FALSE,
AbForest_output=forest[[1]][[2]], vgm_VDJ = vgm$VDJ,
images_tibble = scaling_parameters[[5]],bcs_merge = scaling_parameters[[10]],
sample_names = sample_names,
title = "Number of SHM of clonotype 10", legend_title = "nb of SHM")
}
}
