% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_vis_sample.R
\name{heatmap_sample}
\alias{heatmap_sample}
\title{Generate Heatmap of Ligand-Receptor Interaction Scores}
\usage{
heatmap_sample(
  lr_scores,
  metadata,
  score = c("normalized", "raw"),
  selected_sender = NULL,
  selected_receiver = NULL,
  selected_metadata = NULL
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{score}{Character string indicating which score to use: "normalized" (default) or "raw" .}

\item{selected_sender}{Specific sender cell type to filter, default is None (use all) (character).}

\item{selected_receiver}{Specific receiver cell type to filter, default is None (use all) (character).}

\item{selected_metadata}{List of column names in \code{metadata} to annotate samples (default: None, use all)(character vector).}
}
\value{
Heatmap of average LR interaction scores per sample.
}
\description{
This function generates a heatmap to visualize the ligand-receptor (LR) interaction scores across samples.
Rows represent LR pairs and columns represent samples. Optionally, sample metadata can be used to annotate the columns.
}
\examples{
# Heatmap of LR Interaction Scores
data(lr_scores_eg)
data(metadata_eg)
p <- heatmap_sample(lr_scores_eg, metadata_eg, score = "normalized", selected_sender = "Cardiac",
  selected_receiver = "Perivascular", selected_metadata = c("Sex", "Age_group", "IFN_type"))
print(p)
}
