% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/downsizing_general_design.R
\name{downsizing_general_design}
\alias{downsizing_general_design}
\title{Downsize a general design to a specific design}
\usage{
downsizing_general_design(poped.db)
}
\arguments{
\item{poped.db}{A PopED database}
}
\value{
A list containing:
\item{ni}{A vector of the number of samples in each group.}
\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}
\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}
\item{x}{A matrix for the discrete design variables.  Each row is a group.}
\item{a}{A matrix of covariates.  Each row is a group.}
\item{bpop}{A matrix of fixed effect parameter values.}
}
\description{
Function takes a design with potentially empty design
variables and resuces the design so that a FIM can be calculated using \code{\link{mftot}}.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin basic model

dgd <- downsizing_general_design(poped.db)

output = mftot(dgd$model_switch,poped.db$design$groupsize,
               dgd$ni,dgd$xt,dgd$x,dgd$a,
               poped.db$parameters$param.pt.val$bpop,
               poped.db$parameters$param.pt.val$d,
               poped.db$parameters$param.pt.val$sigma,
               poped.db$parameters$param.pt.val$docc,
               poped.db)
FIM <- output$ret
det(FIM)
}
\seealso{
Other poped_input: \code{\link{convert_variables}};
  \code{\link{create.poped.database}};
  \code{\link{create_design_space}};
  \code{\link{create_design}}; \code{\link{poped.choose}}
}

