/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.portfolioeffect.quant.client.util.Console;
import java.math.BigDecimal;

public class ProgressBar {
    private double cumulPercent;
    private double lastPercent;
    private int oldPercent = -1;
    private long startTime;
    private boolean isON = true;
    private double scale = 1.0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public ProgressBar() {
    }

    public ProgressBar(double scale) {
        this.scale = scale;
    }

    public void printCompletionStatus(int count, int maxCount) {
        double a = count;
        this.printCompletionStatus(a /= (double)maxCount);
    }

    public void printCompletionStatus(double percent) {
        if (percent < this.lastPercent && this.lastPercent >= 1.0) {
            this.lastPercent = 0.0;
        }
        double delta = percent - this.lastPercent;
        this.cumulPercent += delta;
        this.lastPercent = percent;
        int percentInt = (int)Math.round(this.cumulPercent / this.scale * 100.0);
        percentInt = percentInt < this.oldPercent ? this.oldPercent : percentInt;
        int curentPercent = this.oldPercent;
        while (curentPercent <= percentInt) {
            if (curentPercent == 0 && this.oldPercent != 0) {
                this.oldPercent = curentPercent;
                if (this.isON) {
                    Console.write("[" + percentInt + "%");
                }
                this.startTime = System.currentTimeMillis();
                break;
            }
            if (curentPercent == 100 && this.oldPercent != 100) {
                BigDecimal sec = new BigDecimal(String.valueOf((double)(System.currentTimeMillis() - this.startTime) * 0.001)).setScale(2, 4);
                this.oldPercent = curentPercent;
                if (!this.isON) break;
                Console.writeln("100%] ( " + sec + " sec )");
                break;
            }
            if (curentPercent > this.oldPercent && curentPercent % 2 > 0) {
                if (this.isON) {
                    Console.write(".");
                }
            } else if (curentPercent > this.oldPercent && curentPercent % 10 == 0 && this.isON) {
                Console.write(curentPercent + "%");
            }
            this.oldPercent = curentPercent++;
        }
        this.oldPercent = percentInt;
        if (this.cumulPercent >= this.scale) {
            this.reset();
        }
    }

    public void reset() {
        this.cumulPercent = 0.0;
        this.lastPercent = 0.0;
        this.oldPercent = -1;
        this.scale = 1.0;
    }

    public boolean isON() {
        return this.isON;
    }

    public void setON(boolean isON) {
        this.isON = isON;
    }
}

