/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.benchmarktools;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.differential.Delta;
import me.lemire.integercompression.differential.IntegratedBitPacking;

public class BenchmarkBitPacking {
    private static void test(boolean verbose) {
        DecimalFormat dfspeed = new DecimalFormat("0");
        int N = 32;
        int times = 100000;
        Random r = new Random(0L);
        int[] data = new int[32];
        int[] compressed = new int[32];
        int[] uncompressed = new int[32];
        for (int bit = 0; bit < 31; ++bit) {
            long comp = 0L;
            long compwm = 0L;
            long decomp = 0L;
            for (int t = 0; t < 100000; ++t) {
                for (int k = 0; k < 32; ++k) {
                    data[k] = r.nextInt(1 << bit);
                }
                long time1 = System.nanoTime();
                BitPacking.fastpack(data, 0, compressed, 0, bit);
                long time2 = System.nanoTime();
                BitPacking.fastpackwithoutmask(data, 0, compressed, 0, bit);
                long time3 = System.nanoTime();
                BitPacking.fastunpack(compressed, 0, uncompressed, 0, bit);
                long time4 = System.nanoTime();
                comp += time2 - time1;
                compwm += time3 - time2;
                decomp += time4 - time3;
            }
            if (!verbose) continue;
            System.out.println("bit = " + bit + " comp. speed = " + dfspeed.format(3.2E9 / (double)comp) + " comp. speed wm = " + dfspeed.format(3.2E9 / (double)compwm) + " decomp. speed = " + dfspeed.format(3.2E9 / (double)decomp));
        }
    }

    private static void testWithDeltas(boolean verbose) {
        DecimalFormat dfspeed = new DecimalFormat("0");
        int N = 32;
        int times = 100000;
        Random r = new Random(0L);
        int[] data = new int[32];
        int[] compressed = new int[32];
        int[] icompressed = new int[32];
        int[] uncompressed = new int[32];
        for (int bit = 1; bit < 31; ++bit) {
            long comp = 0L;
            long decomp = 0L;
            long icomp = 0L;
            long idecomp = 0L;
            for (int t = 0; t < 100000; ++t) {
                data[0] = r.nextInt(1 << bit);
                for (int k = 1; k < 32; ++k) {
                    data[k] = r.nextInt(1 << bit) + data[k - 1];
                }
                int[] tmpdata = Arrays.copyOf(data, data.length);
                long time1 = System.nanoTime();
                Delta.delta(tmpdata);
                BitPacking.fastpackwithoutmask(tmpdata, 0, compressed, 0, bit);
                long time2 = System.nanoTime();
                BitPacking.fastunpack(compressed, 0, uncompressed, 0, bit);
                Delta.fastinverseDelta(uncompressed);
                long time3 = System.nanoTime();
                if (!Arrays.equals(data, uncompressed)) {
                    throw new RuntimeException("bug");
                }
                comp += time2 - time1;
                decomp += time3 - time2;
                tmpdata = Arrays.copyOf(data, data.length);
                time1 = System.nanoTime();
                IntegratedBitPacking.integratedpack(0, tmpdata, 0, icompressed, 0, bit);
                time2 = System.nanoTime();
                IntegratedBitPacking.integratedunpack(0, icompressed, 0, uncompressed, 0, bit);
                time3 = System.nanoTime();
                if (!Arrays.equals(icompressed, compressed)) {
                    throw new RuntimeException("ibug " + bit);
                }
                if (!Arrays.equals(data, uncompressed)) {
                    throw new RuntimeException("bug " + bit);
                }
                icomp += time2 - time1;
                idecomp += time3 - time2;
            }
            if (!verbose) continue;
            System.out.println("bit = " + bit + " comp. speed = " + dfspeed.format(3.2E9 / (double)comp) + " decomp. speed = " + dfspeed.format(3.2E9 / (double)decomp) + " icomp. speed = " + dfspeed.format(3.2E9 / (double)icomp) + " idecomp. speed = " + dfspeed.format(3.2E9 / (double)idecomp));
        }
    }

    public static void main(String[] args) {
        System.out.println("Testing packing and delta ");
        BenchmarkBitPacking.testWithDeltas(false);
        BenchmarkBitPacking.testWithDeltas(true);
        System.out.println("Testing packing alone ");
        BenchmarkBitPacking.test(false);
        BenchmarkBitPacking.test(true);
    }
}

