/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.util.LinearForecastBuilder;

public class Forecast {
    private LinearForecastBuilder builder = new LinearForecastBuilder();

    public Forecast(Metric metric, String model, String window, String step, String transform, String seasonalityInterval, String updateInterval, String valueType) throws ComputeErrorException {
        this.builder.setTransform(transform);
        this.builder.setRollingWindow(window);
        this.builder.setRegressionUpdateInterval(updateInterval);
        this.builder.setForecastStep(step);
        this.builder.setValueType(valueType);
        this.builder.setTimeShiftEnable(true);
        this.builder.setDependentVariable(metric.getMetric());
        if (!seasonalityInterval.equals("none")) {
            this.builder.setSeasonInterval(seasonalityInterval);
        }
        if (model.equals("HAR")) {
            this.builder.setForecastModel("[{\"windowLength\":\"1d\"},{\"windowLength\":\"5d\"},{\"windowLength\":\"21d\"}]");
        } else if (model.equals("EWMA")) {
            this.builder.setForecastModel("[]");
        } else {
            this.builder.setForecastModel(model);
        }
    }

    public Forecast() {
        this.builder.setTimeShiftEnable(true);
    }

    public Forecast(Metric metric) throws ComputeErrorException {
        this.builder.setTimeShiftEnable(true);
        this.builder.setDependentVariable(metric.getMetric());
    }

    public Forecast setTransform(String transform) {
        this.builder.setTransform(transform);
        return this;
    }

    public Forecast setWindow(String window) {
        this.builder.setRollingWindow(window);
        return this;
    }

    public Forecast setUpdateInterval(String updateInterval) {
        this.builder.setRegressionUpdateInterval(updateInterval);
        return this;
    }

    public Forecast setForecastStep(String step) {
        this.builder.setForecastStep(step);
        return this;
    }

    public Forecast setValueType(String valueType) {
        this.builder.setValueType(valueType);
        return this;
    }

    public Forecast setTimeShiftEnable(boolean flag) {
        this.builder.setTimeShiftEnable(flag);
        return this;
    }

    public Forecast setDependentVariable(Metric metric) throws ComputeErrorException {
        this.builder.setDependentVariable(metric.getMetric());
        return this;
    }

    public Forecast setDependentVariable(String seasonalityInterval) {
        this.builder.setSeasonInterval(seasonalityInterval);
        return this;
    }

    public Forecast setForecastModel(String model) {
        if (model.equals("HAR")) {
            this.builder.setForecastModel("[{\"windowLength\":\"1d\"},{\"windowLength\":\"5d\"},{\"windowLength\":\"21d\"}]");
        } else if (model.equals("EWMA")) {
            this.builder.setForecastModel("[]");
        } else {
            this.builder.setForecastModel(model);
        }
        return this;
    }

    public LinearForecastBuilder getBuilder() {
        return this.builder;
    }

    public Forecast input(Metric metric) throws ComputeErrorException {
        this.builder.addIndependentVariable(metric.getMetric());
        return this;
    }

    public Metric apply() throws ComputeErrorException {
        return new Metric(this.builder.build());
    }

    public Forecast setSeasonalityInterval(String seasonalityInterval) {
        if (!seasonalityInterval.equals("none")) {
            this.builder.setSeasonInterval(seasonalityInterval);
        }
        return this;
    }
}

