/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.ConnectionToServer;
import com.portfolioeffect.quant.client.RequestToServer;
import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.model.ComputeErrorException;

public class Util {
    private static ClientConnection clientConnection;
    private static String userNameS;
    private static String passwordS;
    private static String apiKeyS;
    private static String hostS;

    public static void util_setCredentials(String userName, String password, String apiKey, String host) {
        userNameS = userName;
        passwordS = password;
        apiKeyS = apiKey;
        hostS = host;
        clientConnection = null;
    }

    public static void util_setCredentials(String userName, String password, String apiKey) {
        userNameS = userName;
        passwordS = password;
        apiKeyS = apiKey;
        hostS = "quant07.portfolioeffect.com";
        clientConnection = null;
    }

    public static void setClient(ClientConnection client) {
        clientConnection = client;
    }

    static ClientConnection getClientConnection() throws ComputeErrorException {
        if (clientConnection != null) {
            return clientConnection;
        }
        if (hostS == null) {
            throw new ComputeErrorException("User credentials is not set");
        }
        clientConnection = new ClientConnection();
        clientConnection.setUsername(userNameS);
        clientConnection.setPassword(passwordS);
        clientConnection.setApiKey(apiKeyS);
        clientConnection.setHost(hostS);
        return clientConnection;
    }

    public static void resetClientConnection() {
        ConnectionToServer.resetConnection();
        clientConnection = null;
    }

    public static int util_getComputeTime(String time) throws ComputeErrorException {
        Util.getClientConnection();
        com.portfolioeffect.quant.client.result.Metric result = RequestToServer.getComputeTimeLeft(clientConnection);
        if (result.hasError()) {
            throw new ComputeErrorException("Error: " + result.getErrorMessage());
        }
        if (time.equals("timeMax")) {
            return result.getValueInt("timeMax");
        }
        return result.getValueInt("timeLeft");
    }

    public static void checkResult(Metric result) throws ComputeErrorException {
        if (result.hasError()) {
            throw new ComputeErrorException("Error: " + result.getError());
        }
    }
}

