% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_panel_reduce}
\alias{ml_panel_reduce}
\title{Reduce multiple panels with a binary operator}
\usage{
ml_panel_reduce(features, panels, op = `*`, how = "intersect", fill = NA_real_)
}
\arguments{
\item{features}{List of panels (each a wide data frame with \code{Date}).}

\item{panels}{Character vector of names in \code{features} to reduce (length \eqn{\ge}{>=} 2).}

\item{op}{Binary function to apply elementwise.}

\item{how}{Column-set policy passed to \code{\link[=ml_panel_op]{ml_panel_op()}}.}

\item{fill}{Fill value for \code{how="union"}.}
}
\value{
A data.frame panel (wide) with the reduced result.
}
\description{
Folds a list of panels using \code{ml_panel_op()} across a set of named panels.
}
\examples{
\dontrun{
# product of three panels
prod_panel <- ml_panel_reduce(X, c("mom12","vol","rsi14"), op = `*`)
}
}
