% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTAll.R
\name{PrInDTAll}
\alias{PrInDTAll}
\title{Conditional inference tree (ctree) based on all observations}
\usage{
PrInDTAll(datain, classname, ctestv=NA, conf.level=0.95, thres=0.5)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1); default = 0.95}

\item{thres}{Probability threshold for prediction of smaller class (numerical, >= 0 and < 1); default = 0.5}
}
\value{
\describe{
\item{treeall}{ctree based on all observations}
\item{baAll}{balanced accuracy of 'treeall'}
\item{interpAll}{criterion of interpretability of 'treeall' (TRUE / FALSE)}
\item{confAll}{confusion matrix of 'treeall'}
}
}
\description{
ctree based on all observations. Interpretability is checked (see 'ctestv'); probability threshold can be specified.

\strong{Reference}: Weihs, C., Buschfeld, S. 2021a. Combining Prediction and Interpretation in  Decision Trees (PrInDT) - 
a Linguistic Example. arXiv:2103.02336
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)} where 'name' is the output data 
frame of the function.\cr
}
\examples{
datastrat <- PrInDT::data_zero
data <- na.omit(datastrat)
ctestv <- rbind('ETH == {C2a,C1a}','MLU == {1, 3}')
conf.level <- 0.99 # 1 - significance level (mincriterion) in ctree
outAll <- PrInDTAll(data,"real",ctestv,conf.level) 
print(outAll) # print model based on all observations
plot(outAll) # plot model based on all observations

}
