% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTRstruc.R
\name{PrInDTRstruc}
\alias{PrInDTRstruc}
\title{Structured subsampling for regression}
\usage{
PrInDTRstruc(datain,regname,ctestv=NA,Struc=NA,vers="d",M=NA,Mit=NA,N=99,Pit=NA,
               pobs=c(0.9,0.7),ppre=c(0.9,0.7),conf.level=0.95,minsplit=NA,minbucket=NA,
               valdat=datain,indrep=0)
}
\arguments{
\item{datain}{Input data frame with continuous target variable 'regname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{regname}{Name of target variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
Example: ctestv <- rbind('variable1 == \{value1, value2\}','variable2 <= value3'), where
character strings specified in 'value1', 'value2' are not allowed as results of a splitting operation in variable 1 in a tree.\cr
For restrictions of the type 'variable <= xxx', all split results in a tree are excluded with 'variable <= yyy' and yyy <= xxx.\cr
Trees with split results specified in 'ctestv' are not accepted during optimization.\cr
A concrete example is: 'ctestv <- rbind('ETH == \{C2a, C1a\}','AGE <= 20')' for variables 'ETH' and 'AGE' and values 'C2a','C1a', and '20';\cr
If no restrictions exist, the default = NA is used.}

\item{Struc}{= list(name,check,labs), cf. description for explanations; Struc not needed for vers="b"}

\item{vers}{Version of structured subsampling: "a", "b", "c", "d", cf. description; \cr
default = "d"}

\item{M}{Number of repetitions of subsampling from substructure (integer) in versions "a" and "d";\cr
default = 99}

\item{Mit}{List of number of elements of substructure (integers); \cr
default = c((Cl-4):Cl), Cl = maximum number elements in both categories}

\item{N}{Number of repetitions of subsampling from predictors (integer) in versions "b" and "c";\cr
default = 99}

\item{Pit}{List of number of predictors (integers)\cr
default = c(max(1,(D-3)):D), D = maximum number of predictors}

\item{pobs}{Percentage(s) of observations for subsampling in versions "c" and "d";\cr
default=c(0.9,0.7)}

\item{ppre}{Percentage(s) of predictors for subsampling in versions "c" and "d";\cr
default=c(0.9,0.7)}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{minsplit}{Minimum number of elements in a node to be splitted;\cr
default = 20}

\item{minbucket}{Minimum number of elements in a node;\cr
default = 7}

\item{valdat}{Validation data; default = datain}

\item{indrep}{Indicator for repeated measurements, i.e. more than one observation with the same class for each element;\cr 
indrep=1: Struc=list(name) only; default = 0}
}
\value{
\describe{
  \item{outmax}{Best tree} 
  \item{interp}{Number of interpretable trees, overall number of trees} 
  \item{ntmax}{Size of training set for best tree} 
  \item{R2max}{R squared of best tree}
  \item{R2sub}{Mean R squared of objects in substructure}
  \item{MAEmax}{MAE (Mean Absolute Error) of best tree}
  \item{MAEsub}{Mean MAE of objects in substructure}
  \item{ind1max}{Elements of 1st category of substructure used by best tree} 
  \item{ind2max}{Elements of 2nd category of substructure used by best tree} 
  \item{indmax}{Predictors used by best tree} 
  \item{gmaxTrain}{Training set for best tree} 
  \item{labs}{labs from Struc} 
  \item{vers}{Version used for structured subsampling} 
  \item{lMit}{Number of different numbers of substructure elements}
  \item{lPit}{Number of different numbers of predictors}
  \item{M}{Number of repetitions of selection of substructure elements} 
  \item{N}{Number of repetitions of selection of predictors}
  \item{indrep}{Indicator of repeated measurements: indrep=1} 
}
}
\description{
The function \code{\link{PrInDTRstruc}} applies structured subsampling for finding an optimal subsample to model
the relationship between the continuous variable 'regname' and all other factor and numerical variables
in the data frame 'datain' by means of 'M' repetitions of subsampling from a substructure and 'N' repetitions of subsampling from the predictors. 
The optimization citerion is the goodness of fit R2 on the validation sample 'valdat' (default = 'datain').  
The trees generated from undersampling can be restricted by not accepting trees 
including split results specified in the character strings of the vector 'ctestv'.\cr
The substructure of the observations used for subsampling is specified by the list 'Struc' which consists of the variable 'name' representing the substructure,
the name 'check' of the variable with the information about the categories of the substructure, and the matrix 'labs' which specifies the values of 'check'
corresponding to two categories in its rows, i.e. in 'labs[1,]' and 'labs[2,]'. The names of the categories have to be specified by \code{rownames(labs)}.\cr
The number of predictors 'Pit' to be included in the model and the number of elements of the substructure 'Mit' have to be specified (lists allowed).\cr
The percentages of involved observations and predictors can be controlled by the parameters 'pobs' and 'ppre', respectively.\cr
The parameter 'Struc' is needed for all versions of subsampling except "b". Four different versions of structured subsampling exist:\cr 
a) just of the elements in the substructure with parameters 'M' and 'Mit',\cr
b) just of the predictors with parameters 'N' and 'Pit',\cr
c) of the predictors and for each subset of predictors subsampling of the elements of the substructure with parameters 'M', 'N', 'Mit', 'Pit', 'pobs', and 'ppre', and\cr
d) of the elements of the substructure and for each of these subsets subsampling of the predictors with the same parameters as version c).\cr
The parameters 'conf.level', 'minsplit', and 'minbucket' can be used to control the size of the trees.\cr
Besides the maximal R2, the minimal MAE (Mean Absolute Error) is reported. \cr\cr
Repeated measurements can also be handled by this function (indrep=1). They are multiple measurements of the same variable taken on the same subjects (or objects) either under different conditions 
or over two or more time periods.\cr
The variable with the repeatedly observed subjects (or objects) is assumed to be 'name' in 'Struc'.\cr
The measure MAE is split according to the values of 'name'.
}
\details{
See Buschfeld & Weihs (2025), Optimizing decision trees for the analysis of World Englishes and sociolinguistic data. Cambridge University Press, section 4.5.4, for further information.

Standard output can be produced by means of \code{print(name$besttree)} or just \code{name$besttree} as well as \code{plot(name$besttree)} where 'name' is the output data 
frame of the function.\cr
}
\examples{
data <- PrInDT::data_vowel
data <- na.omit(data)
CHILDvowel <- data$Nickname
data$Nickname <- NULL
data$syllables <- 3 - data$syllables
data$speed <- data$word_duration / data$syllables  ## NEW NEW
names(data)[names(data) == "target"] <- "vowel_length"
# interpretation restrictions (split exclusions)
ctestv <- rbind('ETH == {C2a, C1a}','MLU == {1, 3}') # split exclusions
name <- CHILDvowel
check <- "data$ETH"
labs <- matrix(1:6,nrow=2,ncol=3)
labs[1,] <- c("C1a","C1b","C1c")
labs[2,] <- c("C2a","C2b","C2c")
rownames(labs) <- c("children 1","children 2")
Struc <- list(name=name,check=check,labs=labs)
outstruc <- PrInDTRstruc(data,"vowel_length",ctestv=ctestv,Struc=Struc,vers="d",
                  M=3,Mit=21,N=9,pobs=c(0.95,0.7),ppre=c(1,0.7),conf.level=0.99)
outstruc
plot(outstruc)

}
